"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingTimestamp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _common = require("@kbn/kibana-react-plugin/common");
var _eui = require("@elastic/eui");
var _use_in_progress_image = require("./use_in_progress_image");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _contexts = require("../../../../../contexts");
var _no_image_display = require("./no_image_display");
var _step_image_caption = require("./step_image_caption");
var _step_image_popover = require("./step_image_popover");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDiv = _common.euiStyled.div`
  figcaption {
    display: none;
  }
`;
const PingTimestamp = ({
  label,
  checkGroup,
  stepStatus,
  allStepsLoaded = true,
  initialStepNo = 1
}) => {
  var _screenshotRef$ref, _screenshotRef$ref$sc, _screenshotRef$ref$sc2, _screenshotRef$ref$sc3;
  const [stepNumber, setStepNumber] = (0, _react.useState)(initialStepNo);
  const [isImagePopoverOpen, setIsImagePopoverOpen] = (0, _react.useState)(false);
  const [stepImages, setStepImages] = (0, _react.useState)([]);
  const intersectionRef = _react.default.useRef(null);
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const imgPath = `${basePath}/internal/uptime/journey/screenshot/${checkGroup}/${stepNumber}`;
  const intersection = (0, _useIntersection.default)(intersectionRef, {
    root: null,
    rootMargin: '0px',
    threshold: 1
  });
  const [screenshotRef, setScreenshotRef] = (0, _react.useState)(undefined);
  const isScreenshotRefValid = Boolean(screenshotRef && (screenshotRef === null || screenshotRef === void 0 ? void 0 : (_screenshotRef$ref = screenshotRef.ref) === null || _screenshotRef$ref === void 0 ? void 0 : (_screenshotRef$ref$sc = _screenshotRef$ref.screenshotRef) === null || _screenshotRef$ref$sc === void 0 ? void 0 : (_screenshotRef$ref$sc2 = _screenshotRef$ref$sc.synthetics) === null || _screenshotRef$ref$sc2 === void 0 ? void 0 : (_screenshotRef$ref$sc3 = _screenshotRef$ref$sc2.step) === null || _screenshotRef$ref$sc3 === void 0 ? void 0 : _screenshotRef$ref$sc3.index) === stepNumber);
  const {
    data,
    loading
  } = (0, _use_in_progress_image.useInProgressImage)({
    hasImage: Boolean(stepImages[stepNumber - 1]) || isScreenshotRefValid,
    hasIntersected: Boolean(intersection && intersection.intersectionRatio === 1),
    stepStatus,
    imgPath
  });
  (0, _react.useEffect)(() => {
    if ((0, _runtime_types.isScreenshotRef)(data)) {
      setScreenshotRef(data);
    } else if ((0, _runtime_types.isScreenshotImageBlob)(data)) {
      setStepImages(prevState => [...prevState, data === null || data === void 0 ? void 0 : data.src]);
    }
  }, [data]);
  let imgSrc;
  if ((0, _runtime_types.isScreenshotImageBlob)(data)) {
    var _stepImages;
    imgSrc = (_stepImages = stepImages === null || stepImages === void 0 ? void 0 : stepImages[stepNumber - 1]) !== null && _stepImages !== void 0 ? _stepImages : data.src;
  }
  const captionContent = (0, _translations.formatCaptionContent)(stepNumber, data === null || data === void 0 ? void 0 : data.maxSteps);
  const [numberOfCaptions, setNumberOfCaptions] = (0, _react.useState)(0);
  const ImageCaption = /*#__PURE__*/_react.default.createElement(_step_image_caption.StepImageCaption, {
    captionContent: captionContent,
    imgSrc: imgSrc,
    imgRef: screenshotRef,
    maxSteps: data === null || data === void 0 ? void 0 : data.maxSteps,
    setStepNumber: setStepNumber,
    stepNumber: stepNumber,
    isLoading: Boolean(loading),
    label: label,
    onVisible: val => setNumberOfCaptions(prevVal => val ? prevVal + 1 : prevVal - 1)
  });
  (0, _react.useEffect)(() => {
    // This is a hack to get state if image is in full screen, we should refactor
    // it once eui image exposes it's full screen state
    // we are checking if number of captions are 2, that means
    // image is in full screen mode since caption is also rendered on
    // full screen image
    // we dont want to change image displayed in thumbnail
    if (numberOfCaptions === 1 && stepNumber !== initialStepNo) {
      setStepNumber(initialStepNo);
    }
  }, [numberOfCaptions, initialStepNo, stepNumber]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StepDiv, {
    onMouseEnter: () => setIsImagePopoverOpen(true),
    onMouseLeave: () => setIsImagePopoverOpen(false),
    ref: intersectionRef
  }, (imgSrc || screenshotRef) && /*#__PURE__*/_react.default.createElement(_step_image_popover.StepImagePopover, {
    captionContent: captionContent,
    imageCaption: ImageCaption,
    imgSrc: imgSrc,
    imgRef: screenshotRef,
    isImagePopoverOpen: isImagePopoverOpen
  }), !imgSrc && !screenshotRef && /*#__PURE__*/_react.default.createElement(_no_image_display.NoImageDisplay, {
    imageCaption: ImageCaption,
    isLoading: loading || !allStepsLoaded
  }))), label && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap"
  }, label)));
};
exports.PingTimestamp = PingTimestamp;