"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsPolicyCreateExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _deprecate_notice_modal = require("./deprecate_notice_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Exports Synthetics-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const SyntheticsPolicyCreateExtension = /*#__PURE__*/(0, _react.memo)(({
  newPolicy
}) => {
  (0, _public.useTrackPageview)({
    app: 'fleet',
    path: 'syntheticsCreate'
  });
  (0, _public.useTrackPageview)({
    app: 'fleet',
    path: 'syntheticsCreate',
    delay: 15000
  });
  const {
    application
  } = (0, _public2.useKibana)().services;
  const {
    package: pkg
  } = newPolicy;
  const onCancel = (0, _react.useCallback)(() => {
    application === null || application === void 0 ? void 0 : application.navigateToApp('integrations', {
      path: `/detail/${pkg === null || pkg === void 0 ? void 0 : pkg.name}-${pkg === null || pkg === void 0 ? void 0 : pkg.version}/overview`
    });
  }, [application, pkg === null || pkg === void 0 ? void 0 : pkg.name, pkg === null || pkg === void 0 ? void 0 : pkg.version]);
  return /*#__PURE__*/_react.default.createElement(_deprecate_notice_modal.DeprecateNoticeModal, {
    onCancel: onCancel
  });
});
exports.SyntheticsPolicyCreateExtension = SyntheticsPolicyCreateExtension;
SyntheticsPolicyCreateExtension.displayName = 'SyntheticsPolicyCreateExtension';