"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorHeaderLink = InspectorHeaderLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _uptime_settings_context = require("../../../contexts/uptime_settings_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InspectorHeaderLink() {
  const {
    services: {
      inspector,
      uiSettings
    }
  } = (0, _public.useKibana)();
  const {
    isDev
  } = (0, _uptime_settings_context.useUptimeSettingsContext)();
  const {
    inspectorAdapters
  } = (0, _public2.useInspectorContext)();
  const isInspectorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_public2.enableInspectEsQueries);
  const inspect = () => {
    inspector.open(inspectorAdapters);
  };
  if (!isInspectorEnabled && !isDev) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: inspect
  }, _i18n.i18n.translate('xpack.synthetics.inspectButtonText', {
    defaultMessage: 'Inspect'
  }));
}