"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDateRangeFromChartElement = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDateRangeFromChartElement = (elementData, minInterval) => {
  const startRange = elementData[0].x;
  return {
    dateRangeStart: (0, _moment.default)(startRange).toISOString(),
    dateRangeEnd: (0, _moment.default)(startRange).add(minInterval, 'ms').toISOString()
  };
};
exports.getDateRangeFromChartElement = getDateRangeFromChartElement;