"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationAnomaliesBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _public = require("@kbn/ml-plugin/public");
var _annotation_tooltip = require("./annotation_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DurationAnomaliesBar = ({
  anomalies,
  hiddenLegends
}) => {
  const anomalyAnnotations = new Map();
  Object.keys(_public.ANOMALY_SEVERITY).forEach(severityLevel => {
    anomalyAnnotations.set(severityLevel.toLowerCase(), {
      rect: [],
      color: ''
    });
  });
  if (anomalies !== null && anomalies !== void 0 && anomalies.anomalies) {
    const records = anomalies.anomalies;
    records.forEach(record => {
      var _record$source$observ, _record$source$observ2;
      let recordObsvLoc = (_record$source$observ = (_record$source$observ2 = record.source['observer.geo.name']) === null || _record$source$observ2 === void 0 ? void 0 : _record$source$observ2[0]) !== null && _record$source$observ !== void 0 ? _record$source$observ : 'N/A';
      if (recordObsvLoc === '') {
        recordObsvLoc = 'N/A';
      }
      if (hiddenLegends.length && hiddenLegends.includes(`loc-avg-${recordObsvLoc}`)) {
        return;
      }
      const severityLevel = (0, _public.getSeverityType)(record.severity);
      const tooltipData = {
        time: record.source.timestamp,
        score: record.severity,
        severity: severityLevel,
        color: (0, _public.getSeverityColor)(record.severity)
      };
      const anomalyRect = {
        coordinates: {
          x0: (0, _moment.default)(record.source.timestamp).valueOf(),
          x1: (0, _moment.default)(record.source.timestamp).add(record.source.bucket_span, 's').valueOf()
        },
        details: JSON.stringify(tooltipData)
      };
      anomalyAnnotations.get(severityLevel).rect.push(anomalyRect);
      anomalyAnnotations.get(severityLevel).color = (0, _public.getSeverityColor)(record.severity);
    });
  }
  const getRectStyle = color => {
    return {
      fill: color,
      opacity: 1,
      strokeWidth: 2,
      stroke: color
    };
  };
  const TooltipFormatter = ({
    details
  }) => {
    return /*#__PURE__*/_react.default.createElement(_annotation_tooltip.AnnotationTooltip, {
      details: details || ''
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Array.from(anomalyAnnotations).map(([keyIndex, rectAnnotation]) => {
    return rectAnnotation.rect.length > 0 ? /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
      dataValues: rectAnnotation.rect,
      key: keyIndex,
      id: keyIndex,
      style: getRectStyle(rectAnnotation.color),
      renderTooltip: TooltipFormatter
    }) : null;
  }));
};
exports.DurationAnomaliesBar = DurationAnomaliesBar;