"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCertSearch = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _selectors = require("../../state/selectors");
var _get_certs_request_body = require("../../../../common/requests/get_certs_request_body");
var _contexts = require("../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCertSearch = ({
  pageIndex,
  size = _get_certs_request_body.DEFAULT_SIZE,
  search,
  sortBy = _get_certs_request_body.DEFAULT_SORT,
  direction = _get_certs_request_body.DEFAULT_DIRECTION
}) => {
  var _settings$settings, _settings$settings2;
  const settings = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const searchBody = (0, _get_certs_request_body.getCertsRequestBody)({
    pageIndex,
    size,
    search,
    sortBy,
    direction,
    to: _get_certs_request_body.DEFAULT_TO,
    from: _get_certs_request_body.DEFAULT_FROM
  });
  const esParams = (0, _public.createEsParams)({
    index: (_settings$settings = settings.settings) === null || _settings$settings === void 0 ? void 0 : _settings$settings.heartbeatIndices,
    body: searchBody
  });
  const {
    data: result,
    loading
  } = (0, _public.useEsSearch)(esParams, [(_settings$settings2 = settings.settings) === null || _settings$settings2 === void 0 ? void 0 : _settings$settings2.heartbeatIndices, size, pageIndex, lastRefresh, search, sortBy, direction], {
    name: 'getTLSCertificates'
  });
  return result ? {
    ...(0, _get_certs_request_body.processCertsResult)(result),
    loading
  } : {
    certs: [],
    total: 0,
    loading
  };
};
exports.useCertSearch = useCertSearch;