"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificateList = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _cert_status = require("./cert_status");
var _cert_monitors = require("./cert_monitors");
var labels = _interopRequireWildcard(require("./translations"));
var _fingerprint_col = require("./fingerprint_col");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CertificateList = ({
  page,
  certificates,
  sort,
  onChange
}) => {
  var _certificates$total, _certificates$certs;
  const onTableChange = newVal => {
    onChange(newVal.page, newVal.sort);
  };
  const pagination = {
    pageIndex: page.index,
    pageSize: page.size,
    totalItemCount: (_certificates$total = certificates === null || certificates === void 0 ? void 0 : certificates.total) !== null && _certificates$total !== void 0 ? _certificates$total : 0,
    pageSizeOptions: [10, 25, 50, 100],
    showPerPageOptions: true
  };
  const columns = [{
    field: 'not_after',
    name: labels.STATUS_COL,
    sortable: true,
    render: (val, item) => /*#__PURE__*/_react.default.createElement(_cert_status.CertStatus, {
      cert: item
    })
  }, {
    name: labels.COMMON_NAME_COL,
    field: 'common_name',
    sortable: true
  }, {
    name: labels.MONITORS_COL,
    field: 'monitors',
    render: monitors => /*#__PURE__*/_react.default.createElement(_cert_monitors.CertMonitors, {
      monitors: monitors
    })
  }, {
    name: labels.ISSUED_BY_COL,
    field: 'issuer',
    sortable: true
  }, {
    name: labels.VALID_UNTIL_COL,
    field: 'not_after',
    sortable: true,
    render: value => (0, _moment.default)(value).format('L LT')
  }, {
    name: labels.AGE_COL,
    field: 'not_before',
    sortable: true,
    render: value => (0, _moment.default)().diff((0, _moment.default)(value), 'days') + ' ' + labels.DAYS
  }, {
    name: labels.FINGERPRINTS_COL,
    field: 'sha256',
    render: (val, item) => /*#__PURE__*/_react.default.createElement(_fingerprint_col.FingerprintCol, {
      cert: item
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: certificates.loading,
    columns: columns,
    items: (_certificates$certs = certificates === null || certificates === void 0 ? void 0 : certificates.certs) !== null && _certificates$certs !== void 0 ? _certificates$certs : [],
    pagination: pagination,
    onChange: onTableChange,
    sorting: {
      sort: {
        field: sort.field,
        direction: sort.direction
      }
    },
    noItemsMessage: certificates.loading ? labels.LOADING_CERTIFICATES : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "uptimeCertsEmptyMessage"
    }, labels.NO_CERTS_AVAILABLE)
  });
};
exports.CertificateList = CertificateList;