"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormWrapped = useFormWrapped;
var _react = require("react");
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFormWrapped(props) {
  const form = (0, _reactHookForm.useForm)(props);
  const euiRegister = (0, _react.useCallback)((name, ...registerArgs) => {
    const {
      ref,
      ...restOfRegister
    } = form.register(name, ...registerArgs);
    return {
      inputRef: ref,
      ref,
      ...restOfRegister
    };
  }, [form]);
  const formState = form.formState;
  return (0, _react.useMemo)(() => ({
    ...form,
    register: euiRegister,
    formState
  }), [euiRegister, form, formState]);
}