"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseTimestamp = exports.getShortTimeStamp = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseTimestamp = tsValue => {
  let parsed = Date.parse(tsValue);
  if (isNaN(parsed)) {
    parsed = parseInt(tsValue, 10);
  }
  return (0, _moment.default)(parsed);
};
exports.parseTimestamp = parseTimestamp;
const getShortTimeStamp = (timeStamp, relative = false) => {
  if (relative) {
    var _moment$locale;
    const prevLocale = (_moment$locale = _moment.default.locale()) !== null && _moment$locale !== void 0 ? _moment$locale : 'en';
    const shortLocale = _moment.default.locale(_constants.SHORT_TS_LOCALE) === _constants.SHORT_TS_LOCALE;
    if (!shortLocale) {
      _moment.default.defineLocale(_constants.SHORT_TS_LOCALE, _constants.SHORT_TIMESPAN_LOCALE);
    }
    let shortTimestamp;
    if (typeof timeStamp === 'string') {
      shortTimestamp = parseTimestamp(timeStamp).fromNow();
    } else {
      shortTimestamp = timeStamp.fromNow();
    }

    // Reset it so, it doesn't impact other part of the app
    _moment.default.locale(prevLocale);
    return shortTimestamp;
  } else {
    if ((0, _moment.default)().diff(timeStamp, 'd') >= 1) {
      return timeStamp.format('ll LTS');
    }
    return timeStamp.format('LTS');
  }
};
exports.getShortTimeStamp = getShortTimeStamp;