"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseTimestamp = exports.microsToMillis = exports.getShortTimeStamp = exports.formatDuration = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// one second = 1 million micros
const ONE_SECOND_AS_MICROS = 1000000;

// the limit for converting to seconds is >= 1 sec
const MILLIS_LIMIT = ONE_SECOND_AS_MICROS * 1;
const NUM_MICROSECONDS_IN_MILLISECOND = 1000;

/**
 * This simply converts microseconds to milliseconds. People tend to prefer ms to us
 * when visualizing request duration times.
 */
const microsToMillis = microseconds => {
  if (!microseconds && microseconds !== 0) return null;
  return Math.floor(microseconds / NUM_MICROSECONDS_IN_MILLISECOND);
};
exports.microsToMillis = microsToMillis;
const formatDuration = (durationMicros, {
  noSpace
} = {}) => {
  if (durationMicros < MILLIS_LIMIT) {
    if (noSpace) {
      return _i18n.i18n.translate('xpack.synthetics.overview.durationMsFormattingNoSpace', {
        values: {
          millis: microsToMillis(durationMicros)
        },
        defaultMessage: '{millis}ms'
      });
    }
    return _i18n.i18n.translate('xpack.synthetics.overview.durationMsFormatting', {
      values: {
        millis: microsToMillis(durationMicros)
      },
      defaultMessage: '{millis} ms'
    });
  }
  const seconds = (durationMicros / ONE_SECOND_AS_MICROS).toFixed(0);
  if (noSpace) {
    return _i18n.i18n.translate('xpack.synthetics.overview.durationSecondsFormattingNoSpace', {
      values: {
        seconds
      },
      defaultMessage: '{seconds}s'
    });
  }
  return _i18n.i18n.translate('xpack.synthetics.overview.durationSecondsFormatting', {
    values: {
      seconds
    },
    defaultMessage: '{seconds} s'
  });
};
exports.formatDuration = formatDuration;
const getShortTimeStamp = (timeStamp, relative = false) => {
  if (relative) {
    var _moment$locale;
    const prevLocale = (_moment$locale = _moment.default.locale()) !== null && _moment$locale !== void 0 ? _moment$locale : 'en';
    const shortLocale = _moment.default.locale(_constants.SHORT_TS_LOCALE) === _constants.SHORT_TS_LOCALE;
    if (!shortLocale) {
      _moment.default.defineLocale(_constants.SHORT_TS_LOCALE, _constants.SHORT_TIMESPAN_LOCALE);
    }
    let shortTimestamp;
    if (typeof timeStamp === 'string') {
      shortTimestamp = parseTimestamp(timeStamp).fromNow();
    } else {
      shortTimestamp = timeStamp.fromNow();
    }

    // Reset it so, it doesn't impact other part of the app
    _moment.default.locale(prevLocale);
    return shortTimestamp;
  } else {
    if ((0, _moment.default)().diff(timeStamp, 'd') >= 1) {
      return timeStamp.format('ll LTS');
    }
    return timeStamp.format('LTS');
  }
};
exports.getShortTimeStamp = getShortTimeStamp;
const parseTimestamp = tsValue => {
  let parsed = Date.parse(tsValue);
  if (isNaN(parsed)) {
    parsed = parseInt(tsValue, 10);
  }
  return (0, _moment.default)(parsed);
};
exports.parseTimestamp = parseTimestamp;