"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectSearchText = exports.selectRefreshPaused = exports.selectRefreshInterval = exports.selectMonitorId = exports.selectIsIntegrationsPopupOpen = exports.selectEsKuery = exports.selectBasePath = exports.selectAlertFlyoutVisibility = exports.selectAlertFlyoutType = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uiStateSelector = appState => appState.ui;
const selectBasePath = (0, _reselect.createSelector)(uiStateSelector, ({
  basePath
}) => basePath);
exports.selectBasePath = selectBasePath;
const selectIsIntegrationsPopupOpen = (0, _reselect.createSelector)(uiStateSelector, ({
  integrationsPopoverOpen
}) => integrationsPopoverOpen);
exports.selectIsIntegrationsPopupOpen = selectIsIntegrationsPopupOpen;
const selectAlertFlyoutVisibility = (0, _reselect.createSelector)(uiStateSelector, ({
  alertFlyoutVisible
}) => alertFlyoutVisible);
exports.selectAlertFlyoutVisibility = selectAlertFlyoutVisibility;
const selectAlertFlyoutType = (0, _reselect.createSelector)(uiStateSelector, ({
  alertFlyoutType
}) => alertFlyoutType);
exports.selectAlertFlyoutType = selectAlertFlyoutType;
const selectEsKuery = (0, _reselect.createSelector)(uiStateSelector, ({
  esKuery
}) => esKuery);
exports.selectEsKuery = selectEsKuery;
const selectSearchText = (0, _reselect.createSelector)(uiStateSelector, ({
  searchText
}) => searchText);
exports.selectSearchText = selectSearchText;
const selectMonitorId = (0, _reselect.createSelector)(uiStateSelector, ({
  monitorId
}) => monitorId);
exports.selectMonitorId = selectMonitorId;
const selectRefreshPaused = (0, _reselect.createSelector)(uiStateSelector, ({
  refreshPaused
}) => refreshPaused);
exports.selectRefreshPaused = selectRefreshPaused;
const selectRefreshInterval = (0, _reselect.createSelector)(uiStateSelector, ({
  refreshInterval
}) => refreshInterval);
exports.selectRefreshInterval = selectRefreshInterval;