"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  dynamicSettingsReducer: true,
  settingsReducer: true
};
exports.settingsReducer = exports.dynamicSettingsReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  loading: true,
  connectors: []
};
const dynamicSettingsReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.getDynamicSettingsAction.get, state => {
    state.loading = true;
  }).addCase(_actions.getDynamicSettingsAction.success, (state, action) => {
    state.settings = action.payload;
    state.loading = false;
  }).addCase(_actions.getDynamicSettingsAction.fail, (state, action) => {
    state.loadError = action.payload;
    state.loading = false;
  }).addCase(_actions.setDynamicSettingsAction.get, state => {
    state.loading = true;
  }).addCase(_actions.setDynamicSettingsAction.success, (state, action) => {
    state.settings = action.payload;
    state.loading = false;
  }).addCase(_actions.setDynamicSettingsAction.fail, (state, action) => {
    state.loadError = action.payload;
    state.loading = false;
  }).addCase(_actions.getConnectorsAction.get, state => {
    state.connectorsLoading = true;
  }).addCase(_actions.getConnectorsAction.success, (state, action) => {
    state.connectors = action.payload;
    state.connectorsLoading = false;
  }).addCase(_actions.getConnectorsAction.fail, (state, action) => {
    state.connectorsLoading = false;
  });
});
exports.dynamicSettingsReducer = dynamicSettingsReducer;
const initialSettingState = {
  success: null,
  loading: false,
  error: null
};
const settingsReducer = (0, _toolkit.createReducer)(initialSettingState, builder => {
  builder.addCase(_actions.syncGlobalParamsAction.get, state => {
    state.loading = true;
  }).addCase(_actions.syncGlobalParamsAction.success, (state, action) => {
    state.success = action.payload;
    state.loading = false;
  }).addCase(_actions.syncGlobalParamsAction.fail, (state, action) => {
    state.error = action.payload;
    state.loading = false;
    state.success = false;
  });
});
exports.settingsReducer = settingsReducer;