"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootEffect = void 0;
var _effects = require("redux-saga/effects");
var _global_params = require("./global_params");
var _effects2 = require("./manual_test_runs/effects");
var _effects3 = require("./alert_rules/effects");
var _elasticsearch = require("./elasticsearch");
var _effects4 = require("./settings/effects");
var _settings = require("./settings");
var _private_locations = require("./private_locations");
var _effects5 = require("./network_events/effects");
var _monitor_details = require("./monitor_details");
var _synthetics_enablement = require("./synthetics_enablement");
var _monitor_list = require("./monitor_list");
var _overview = require("./overview");
var _service_locations = require("./service_locations");
var _browser_journey = require("./browser_journey");
var _ping_status = require("./ping_status");
var _overview_status = require("./overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rootEffect = function* root() {
  yield (0, _effects.all)([(0, _effects.fork)(_synthetics_enablement.fetchSyntheticsEnablementEffect), (0, _effects.fork)(_monitor_list.upsertMonitorEffect), (0, _effects.fork)(_service_locations.fetchServiceLocationsEffect), (0, _effects.fork)(_monitor_list.fetchMonitorListEffect), (0, _effects.fork)(_monitor_details.fetchSyntheticsMonitorEffect), (0, _effects.fork)(_overview.fetchMonitorOverviewEffect), (0, _effects.fork)(_browser_journey.browserJourneyEffects), (0, _effects.fork)(_overview_status.fetchOverviewStatusEffect), (0, _effects.fork)(_effects5.fetchNetworkEventsEffect), (0, _effects.fork)(_ping_status.fetchPingStatusesEffect), (0, _effects.fork)(_private_locations.fetchAgentPoliciesEffect), (0, _effects.fork)(_effects4.fetchDynamicSettingsEffect), (0, _effects.fork)(_effects4.setDynamicSettingsEffect), (0, _effects.fork)(_effects4.fetchAlertConnectorsEffect), (0, _effects.fork)(_settings.syncGlobalParamsEffect), (0, _effects.fork)(_effects3.enableDefaultAlertingEffect), (0, _effects.fork)(_monitor_list.enableMonitorAlertEffect), (0, _effects.fork)(_effects3.updateDefaultAlertingEffect), (0, _effects.fork)(_elasticsearch.executeEsQueryEffect), (0, _effects.fork)(_browser_journey.fetchJourneyStepsEffect), (0, _effects.fork)(_effects2.fetchManualTestRunsEffect), (0, _effects.fork)(_global_params.addGlobalParamEffect), (0, _effects.fork)(_global_params.editGlobalParamEffect), (0, _effects.fork)(_global_params.getGlobalParamEffect)]);
};
exports.rootEffect = rootEffect;