"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsPrivateLocations = exports.fetchAgentPolicies = exports.deleteSyntheticsPrivateLocations = exports.addSyntheticsPrivateLocations = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLEET_URLS = {
  AGENT_POLICIES: '/api/fleet/agent_policies'
};
const fetchAgentPolicies = async () => {
  return await _api_service.apiService.get(FLEET_URLS.AGENT_POLICIES, {
    page: 1,
    perPage: 10000,
    sortField: 'name',
    sortOrder: 'asc',
    full: true,
    kuery: 'ingest-agent-policies.is_managed : false'
  }, null);
};
exports.fetchAgentPolicies = fetchAgentPolicies;
const addSyntheticsPrivateLocations = async newLocation => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS, newLocation);
};
exports.addSyntheticsPrivateLocations = addSyntheticsPrivateLocations;
const getSyntheticsPrivateLocations = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS);
};
exports.getSyntheticsPrivateLocations = getSyntheticsPrivateLocations;
const deleteSyntheticsPrivateLocations = async locationId => {
  return await _api_service.apiService.delete(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS + `/${locationId}`);
};
exports.deleteSyntheticsPrivateLocations = deleteSyntheticsPrivateLocations;