"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  overviewStatusReducer: true
};
exports.overviewStatusReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  loading: false,
  loaded: false,
  status: null,
  error: null,
  filtersData: null
};
const overviewStatusReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.fetchOverviewStatusAction.get, state => {
    state.status = null;
  }).addCase(_actions.fetchOverviewStatusAction.success, (state, action) => {
    state.status = {
      ...action.payload,
      allConfigs: {
        ...action.payload.upConfigs,
        ...action.payload.downConfigs
      }
    };
    state.loaded = true;
  }).addCase(_actions.fetchOverviewStatusAction.fail, (state, action) => {
    state.error = action.payload;
  }).addCase(_actions.setListOfFiltersActions, (state, action) => {
    state.filtersData = action.payload;
  }).addCase(_actions.clearOverviewStatusErrorAction, state => {
    state.error = null;
  });
});
exports.overviewStatusReducer = overviewStatusReducer;