"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyntheticsMonitor = exports.fetchOverviewStatus = exports.fetchMonitorOverview = void 0;
exports.toStatusOverviewQueryArgs = toStatusOverviewQueryArgs;
var _constants = require("../../../../../common/constants");
var _runtime_types = require("../../../../../common/runtime_types");
var _api_service = require("../../../../utils/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSyntheticsMonitor = async monitorId => {
  return _api_service.apiService.get(`${_constants.API_URLS.SYNTHETICS_MONITORS}/${monitorId}`);
};
exports.fetchSyntheticsMonitor = fetchSyntheticsMonitor;
function toMonitorOverviewQueryArgs(pageState) {
  return {
    sortField: pageState.sortField,
    sortOrder: pageState.sortOrder,
    ...toStatusOverviewQueryArgs(pageState)
  };
}
function toStatusOverviewQueryArgs(pageState) {
  return {
    query: pageState.query,
    tags: pageState.tags,
    locations: pageState.locations,
    projects: pageState.projects,
    schedules: pageState.schedules,
    monitorTypes: pageState.monitorTypes,
    searchFields: []
  };
}
const fetchMonitorOverview = async pageState => {
  const params = toMonitorOverviewQueryArgs(pageState);
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.SYNTHETICS_OVERVIEW, params, _runtime_types.MonitorOverviewResultCodec);
};
exports.fetchMonitorOverview = fetchMonitorOverview;
const fetchOverviewStatus = async pageState => {
  const params = toStatusOverviewQueryArgs(pageState);
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.OVERVIEW_STATUS, params, _runtime_types.OverviewStatusCodec);
};
exports.fetchOverviewStatus = fetchOverviewStatus;