"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMonitorAPI = exports.getMonitorAPI = exports.fetchServiceAPIKey = exports.deletePackagePolicy = exports.createMonitorAPI = void 0;
var _api_service = require("../../../../utils/api_service");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMonitorAPI = async ({
  monitor
}) => {
  return await _api_service.apiService.post(_constants.API_URLS.SYNTHETICS_MONITORS, monitor);
};
exports.createMonitorAPI = createMonitorAPI;
const updateMonitorAPI = async ({
  monitor,
  id
}) => {
  return await _api_service.apiService.put(`${_constants.API_URLS.SYNTHETICS_MONITORS}/${id}`, monitor);
};
exports.updateMonitorAPI = updateMonitorAPI;
const getMonitorAPI = async ({
  id
}) => {
  return await _api_service.apiService.get(`${_constants.API_URLS.SYNTHETICS_MONITORS}/${id}`);
};
exports.getMonitorAPI = getMonitorAPI;
const fetchServiceAPIKey = async () => {
  return await _api_service.apiService.get(_constants.API_URLS.SYNTHETICS_APIKEY);
};
exports.fetchServiceAPIKey = fetchServiceAPIKey;
const deletePackagePolicy = async packagePolicyId => {
  return await _api_service.apiService.delete(_constants.SYNTHETICS_API_URLS.DELETE_PACKAGE_POLICY.replace('{packagePolicyId}', packagePolicyId));
};
exports.deletePackagePolicy = deletePackagePolicy;