"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectMonitorUpsertStatuses = exports.selectMonitorUpsertStatus = exports.selectMonitorListState = exports.selectMonitorFiltersAndQueryState = exports.selectEncryptedSyntheticsSavedMonitors = void 0;
var _reselect = require("reselect");
var _runtime_types = require("../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectMonitorListState = state => state.monitorList;
exports.selectMonitorListState = selectMonitorListState;
const selectEncryptedSyntheticsSavedMonitors = (0, _reselect.createSelector)(selectMonitorListState, state => state === null || state === void 0 ? void 0 : state.data.monitors.map(monitor => ({
  ...monitor.attributes,
  id: monitor.attributes[_runtime_types.ConfigKey.MONITOR_QUERY_ID],
  updated_at: monitor.updated_at,
  created_at: monitor.created_at
})));
exports.selectEncryptedSyntheticsSavedMonitors = selectEncryptedSyntheticsSavedMonitors;
const selectMonitorFiltersAndQueryState = (0, _reselect.createSelector)(selectMonitorListState, state => {
  const {
    monitorTypes,
    tags,
    locations,
    projects,
    schedules
  } = state.pageState;
  const {
    query
  } = state.pageState;
  return {
    monitorTypes,
    tags,
    locations,
    projects,
    schedules,
    query
  };
});
exports.selectMonitorFiltersAndQueryState = selectMonitorFiltersAndQueryState;
const selectMonitorUpsertStatuses = state => state.monitorList.monitorUpsertStatuses;
exports.selectMonitorUpsertStatuses = selectMonitorUpsertStatuses;
const selectMonitorUpsertStatus = configId => state => {
  var _state$monitorList$mo, _state$monitorList$mo2;
  return (_state$monitorList$mo = (_state$monitorList$mo2 = state.monitorList.monitorUpsertStatuses) === null || _state$monitorList$mo2 === void 0 ? void 0 : _state$monitorList$mo2[configId]) !== null && _state$monitorList$mo !== void 0 ? _state$monitorList$mo : null;
};
exports.selectMonitorUpsertStatus = selectMonitorUpsertStatus;