"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyntheticsMonitor = exports.fetchMonitorRecentPings = exports.fetchMonitorLastRun = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorLastRun = async ({
  monitorId,
  locationId
}) => {
  return fetchMonitorRecentPings({
    monitorId,
    locationId,
    size: 1
  });
};
exports.fetchMonitorLastRun = fetchMonitorLastRun;
const fetchMonitorRecentPings = async ({
  monitorId,
  locationId,
  from,
  to,
  size = 10,
  pageIndex = 0
}) => {
  const locations = JSON.stringify([locationId]);
  const sort = 'desc';
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PINGS, {
    monitorId,
    from: from !== null && from !== void 0 ? from : (0, _moment.default)().subtract(30, 'days').toISOString(),
    to: to !== null && to !== void 0 ? to : new Date().toISOString(),
    locations,
    sort,
    size,
    pageIndex
  }, _runtime_types.PingsResponseType);
};
exports.fetchMonitorRecentPings = fetchMonitorRecentPings;
const fetchSyntheticsMonitor = async ({
  monitorId
}) => {
  const savedObject = await _api_service.apiService.get(`${_constants.API_URLS.SYNTHETICS_MONITORS}/${monitorId}`);
  return {
    ...savedObject.attributes,
    updated_at: savedObject.updated_at,
    created_at: savedObject.created_at
  };
};
exports.fetchSyntheticsMonitor = fetchSyntheticsMonitor;