"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  globalParamsReducer: true
};
exports.globalParamsReducer = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _effects = require("./effects");
Object.keys(_effects).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _effects[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _effects[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isLoading: false,
  addError: null,
  isSaving: false,
  editError: null,
  listOfParams: []
};
const globalParamsReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.getGlobalParamAction.get, state => {
    state.isLoading = true;
  }).addCase(_actions.getGlobalParamAction.success, (state, action) => {
    state.isLoading = false;
    state.listOfParams = action.payload;
  }).addCase(_actions.getGlobalParamAction.fail, (state, action) => {
    state.isLoading = false;
  }).addCase(_actions.addNewGlobalParamAction.get, state => {
    state.isSaving = true;
    state.savedData = undefined;
  }).addCase(_actions.addNewGlobalParamAction.success, (state, action) => {
    state.isSaving = false;
    state.savedData = action.payload;
  }).addCase(_actions.addNewGlobalParamAction.fail, (state, action) => {
    state.isSaving = false;
    state.addError = action.payload;
  }).addCase(_actions.editGlobalParamAction.get, state => {
    state.isSaving = true;
    state.savedData = undefined;
  }).addCase(_actions.editGlobalParamAction.success, (state, action) => {
    state.isSaving = false;
    state.savedData = action.payload;
  }).addCase(_actions.editGlobalParamAction.fail, (state, action) => {
    state.isSaving = false;
    state.editError = action.payload;
  });
});
exports.globalParamsReducer = globalParamsReducer;