"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addGlobalParamEffect = addGlobalParamEffect;
exports.editGlobalParamEffect = editGlobalParamEffect;
exports.getGlobalParamEffect = getGlobalParamEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* getGlobalParamEffect() {
  yield (0, _effects.takeLeading)(_actions.getGlobalParamAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.getGlobalParams, _actions.getGlobalParamAction.success, _actions.getGlobalParamAction.fail, undefined, getFailMessage));
}
const getFailMessage = _i18n.i18n.translate('xpack.synthetics.settings.getParams.failed', {
  defaultMessage: 'Failed to get global parameters.'
});
function* addGlobalParamEffect() {
  yield (0, _effects.takeLeading)(_actions.addNewGlobalParamAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.addGlobalParam, _actions.addNewGlobalParamAction.success, _actions.addNewGlobalParamAction.fail, successMessage, failureMessage));
}
const successMessage = _i18n.i18n.translate('xpack.synthetics.settings.addParams.success', {
  defaultMessage: 'Successfully added global parameter.'
});
const failureMessage = _i18n.i18n.translate('xpack.synthetics.settings.addParams.fail', {
  defaultMessage: 'Failed to add global parameter.'
});
function* editGlobalParamEffect() {
  yield (0, _effects.takeLeading)(_actions.editGlobalParamAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.editGlobalParam, _actions.editGlobalParamAction.success, _actions.editGlobalParamAction.fail, editSuccessMessage, editFailureMessage));
}
const editSuccessMessage = _i18n.i18n.translate('xpack.synthetics.settings.editParams.success', {
  defaultMessage: 'Successfully edited global parameter.'
});
const editFailureMessage = _i18n.i18n.translate('xpack.synthetics.settings.editParams.fail', {
  defaultMessage: 'Failed to edit global parameter.'
});