"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateHitCountsAction = exports.setBlockLoadingAction = exports.putCacheSize = exports.putBlocksAction = exports.pruneCacheAction = exports.fetchJourneyAction = exports.fetchBlocksAction = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _actions = require("../utils/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This action denotes a set of blocks is required
const fetchBlocksAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] FETCH BLOCKS');

// This action denotes a request for a set of blocks is in flight
exports.fetchBlocksAction = fetchBlocksAction;
const setBlockLoadingAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] SET BLOCKS IN FLIGHT');

// Block data has been received, and should be added to the store
exports.setBlockLoadingAction = setBlockLoadingAction;
const putBlocksAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] PUT SCREENSHOT BLOCKS');

// Updates the total size of the image blob data cached in the store
exports.putBlocksAction = putBlocksAction;
const putCacheSize = (0, _toolkit.createAction)('[BROWSER JOURNEY] PUT CACHE SIZE');

// Keeps track of the most-requested blocks
exports.putCacheSize = putCacheSize;
const updateHitCountsAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] UPDATE HIT COUNTS');

// Reduce the cache size to the value in the action payload
exports.updateHitCountsAction = updateHitCountsAction;
const pruneCacheAction = (0, _toolkit.createAction)('[BROWSER JOURNEY] PRUNE SCREENSHOT BLOCK CACHE');
exports.pruneCacheAction = pruneCacheAction;
const fetchJourneyAction = (0, _actions.createAsyncAction)('fetchJourneyStepsAction');
exports.fetchJourneyAction = fetchJourneyAction;