"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableDefaultAlertingEffect = enableDefaultAlertingEffect;
exports.updateDefaultAlertingEffect = updateDefaultAlertingEffect;
var _effects = require("redux-saga/effects");
var _i18n = require("@kbn/i18n");
var _actions = require("./actions");
var _fetch_effect = require("../utils/fetch_effect");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* enableDefaultAlertingEffect() {
  yield (0, _effects.takeLeading)(_actions.enableDefaultAlertingAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.enableDefaultAlertingAPI, _actions.enableDefaultAlertingAction.success, _actions.enableDefaultAlertingAction.fail, successMessage, failureMessage));
}
function* updateDefaultAlertingEffect() {
  yield (0, _effects.takeLeading)(_actions.updateDefaultAlertingAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.updateDefaultAlertingAPI, _actions.updateDefaultAlertingAction.success, _actions.updateDefaultAlertingAction.fail, successMessage, failureMessage));
}
const successMessage = _i18n.i18n.translate('xpack.synthetics.settings.enableAlerting', {
  defaultMessage: 'Monitor status rule successfully updated. Changes will take effect on the next rule execution.'
});
const failureMessage = _i18n.i18n.translate('xpack.synthetics.settings.enabledAlert.fail', {
  defaultMessage: 'Failed to update monitor status rule type.'
});