"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMonitorStatusAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_synthetics_monitor_url = require("../../../../../common/utils/get_synthetics_monitor_url");
var _field_names = require("../../../../../common/field_names");
var _translations = require("../../../../../common/rules/synthetics/translations");
var _synthetics_alerts = require("../../../../../common/constants/synthetics_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.SyntheticsMonitorStatusTranslations;
const MonitorStatusAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/monitor_status'))));
const initMonitorStatusAlertType = ({
  core,
  plugins
}) => ({
  id: _synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.MONITOR_STATUS,
  description,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.monitorStatus}`;
  },
  ruleParamsExpression: paramProps => /*#__PURE__*/_react.default.createElement(MonitorStatusAlert, {
    core: core,
    plugins: plugins,
    params: paramProps
  }),
  validate: _ruleParams => {
    return {
      errors: {}
    };
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: true,
  format: ({
    fields
  }) => {
    return {
      reason: fields[_ruleDataUtils.ALERT_REASON] || '',
      link: (0, _get_synthetics_monitor_url.getSyntheticsErrorRouteFromMonitorId)({
        configId: fields.configId,
        locationId: fields['location.id'],
        stateId: fields[_field_names.STATE_ID]
      })
    };
  }
});
exports.initMonitorStatusAlertType = initMonitorStatusAlertType;