"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MonitorStatusAlert;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function MonitorStatusAlert({
  core,
  plugins,
  params
}) {
  _kibana_service.kibanaService.core = core;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alertRule.monitorStatus.description",
    defaultMessage: "Manage synthetics monitor status rule actions."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
}
module.exports = exports.default;