"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsPrivileges = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _overview_status = require("../state/overview_status");
var _constants = require("../../../../common/constants");
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyntheticsPrivileges = () => {
  var _error$body, _error$body$message, _error$body2, _error$body3;
  const {
    error
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  if (error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && (_error$body$message = _error$body.message) !== null && _error$body$message !== void 0 && _error$body$message.startsWith('MissingIndicesPrivileges:')) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: [_constants.SYNTHETICS_INDEX_PATTERN]
    })));
  }
  if (error !== null && error !== void 0 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && _error$body2.message && [_constants.LICENSE_NOT_ACTIVE_ERROR, _constants.LICENSE_MISSING_ERROR, _constants.LICENSE_NOT_SUPPORTED_ERROR].includes(error === null || error === void 0 ? void 0 : (_error$body3 = error.body) === null || _error$body3 === void 0 ? void 0 : _error$body3.message)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(LicenseExpired, null)));
  }
};
exports.useSyntheticsPrivileges = useSyntheticsPrivileges;
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "syntheticsUnprivileged",
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoObservability",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.noFindingsStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.noFindingsStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view Synthetics monitors data, you must update privileges. For more information, contact your Kibana administrator."
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.synthetics.noFindingsStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``)
  })
});
const LicenseExpired = () => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    iconType: "warning",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.license.invalidLicenseTitle",
      defaultMessage: "Invalid License"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.license.invalidLicenseDescription",
      defaultMessage: "The Synthetics UI is not available because your current license has expired or is no longer valid."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmInvalidLicenseNotificationManageYourLicenseButton",
      href: basePath + '/app/management/stack/license_management'
    }, _i18n.i18n.translate('xpack.synthetics.invalidLicense.licenseManagementLink', {
      defaultMessage: 'Manage your license'
    }))]
  });
};