"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorEnableHandler = useMonitorEnableHandler;
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _reactRedux = require("react-redux");
var _types = require("../components/monitors_page/overview/types");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorEnableHandler({
  configId,
  reloadPage,
  labels
}) {
  var _upsertStatuses$confi;
  const dispatch = (0, _reactRedux.useDispatch)();
  const upsertStatuses = (0, _reactRedux.useSelector)(_state.selectMonitorUpsertStatuses);
  const status = (_upsertStatuses$confi = upsertStatuses[configId]) === null || _upsertStatuses$confi === void 0 ? void 0 : _upsertStatuses$confi.status;
  const [nextEnabled, setNextEnabled] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (status === _public.FETCH_STATUS.FAILURE) {
      setNextEnabled(null);
    }
  }, [setNextEnabled, status]);
  const updateMonitorEnabledState = (0, _react.useCallback)(enabled => {
    dispatch((0, _state.fetchUpsertMonitorAction)({
      configId,
      monitor: {
        [_types.ConfigKey.ENABLED]: enabled
      },
      success: {
        message: enabled ? labels.enabledSuccessLabel : labels.disabledSuccessLabel,
        lifetimeMs: 3000,
        testAttribute: 'uptimeMonitorEnabledUpdateSuccess'
      },
      error: {
        message: {
          title: labels.failureLabel
        },
        lifetimeMs: 10000,
        testAttribute: 'uptimeMonitorEnabledUpdateFailure'
      }
    }));
    setNextEnabled(enabled);
    if (reloadPage) reloadPage();
  }, [dispatch, configId, labels.disabledSuccessLabel, labels.enabledSuccessLabel, labels.failureLabel, setNextEnabled, reloadPage]);
  return {
    isEnabled: nextEnabled,
    updateMonitorEnabledState,
    status
  };
}