"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLast50DurationChart = useLast50DurationChart;
var _react = require("react");
var _use_last_x_checks = require("./use_last_x_checks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fields = ['monitor.duration.us'];
function useLast50DurationChart({
  monitorId,
  locationId,
  timestamp
}) {
  const {
    hits,
    loading
  } = (0, _use_last_x_checks.useLastXChecks)({
    monitorId,
    locationId,
    fields,
    size: 50,
    timestamp
  });
  const {
    data,
    median,
    min,
    max,
    avg
  } = (0, _react.useMemo)(() => {
    var _sortedByDuration$Mat, _sortedByDuration$Mat2, _sortedByDuration$, _sortedByDuration$$mo, _sortedByDuration, _sortedByDuration$mon;
    if (loading) {
      return {
        data: [],
        median: 0,
        avg: 0,
        min: 0,
        max: 0
      };
    }

    // calculate min, max, average duration and median

    const coords = hits.reverse() // results are returned in desc order by timestamp. Reverse to ensure the data is in asc order by timestamp
    .map((hit, index) => {
      var _hit$monitorDuration;
      const duration = hit === null || hit === void 0 ? void 0 : (_hit$monitorDuration = hit['monitor.duration.us']) === null || _hit$monitorDuration === void 0 ? void 0 : _hit$monitorDuration[0];
      if (duration === undefined) {
        return null;
      }
      return {
        x: index,
        y: duration
      };
    }).filter(item => item !== null);
    const sortedByDuration = [...hits].sort((a, b) => {
      var _a$monitorDurationU, _b$monitorDurationU;
      return ((a === null || a === void 0 ? void 0 : (_a$monitorDurationU = a['monitor.duration.us']) === null || _a$monitorDurationU === void 0 ? void 0 : _a$monitorDurationU[0]) || 0) - ((b === null || b === void 0 ? void 0 : (_b$monitorDurationU = b['monitor.duration.us']) === null || _b$monitorDurationU === void 0 ? void 0 : _b$monitorDurationU[0]) || 0);
    });
    return {
      data: coords,
      median: ((_sortedByDuration$Mat = sortedByDuration[Math.floor(hits.length / 2)]) === null || _sortedByDuration$Mat === void 0 ? void 0 : (_sortedByDuration$Mat2 = _sortedByDuration$Mat['monitor.duration.us']) === null || _sortedByDuration$Mat2 === void 0 ? void 0 : _sortedByDuration$Mat2[0]) || 0,
      avg: sortedByDuration.reduce((acc, curr) => {
        var _curr$monitorDuratio;
        return acc + ((curr === null || curr === void 0 ? void 0 : (_curr$monitorDuratio = curr['monitor.duration.us']) === null || _curr$monitorDuratio === void 0 ? void 0 : _curr$monitorDuratio[0]) || 0);
      }, 0) / hits.length,
      min: ((_sortedByDuration$ = sortedByDuration[0]) === null || _sortedByDuration$ === void 0 ? void 0 : (_sortedByDuration$$mo = _sortedByDuration$['monitor.duration.us']) === null || _sortedByDuration$$mo === void 0 ? void 0 : _sortedByDuration$$mo[0]) || 0,
      max: ((_sortedByDuration = sortedByDuration[sortedByDuration.length - 1]) === null || _sortedByDuration === void 0 ? void 0 : (_sortedByDuration$mon = _sortedByDuration['monitor.duration.us']) === null || _sortedByDuration$mon === void 0 ? void 0 : _sortedByDuration$mon[0]) || 0
    };
  }, [hits, loading]);
  return (0, _react.useMemo)(() => ({
    data,
    medianDuration: median,
    avgDuration: avg,
    minDuration: min,
    maxDuration: max,
    loading
  }), [data, median, avg, min, max, loading]);
}