"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canUpdatePrivateMonitor = canUpdatePrivateMonitor;
exports.useCanManagePrivateLocation = useCanManagePrivateLocation;
exports.useCanUpdatePrivateMonitor = useCanUpdatePrivateMonitor;
exports.useFleetPermissions = useFleetPermissions;
var _public = require("@kbn/kibana-react-plugin/public");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFleetPermissions() {
  const {
    fleet
  } = (0, _public.useKibana)().services;
  const canSaveIntegrations = Boolean(fleet === null || fleet === void 0 ? void 0 : fleet.authz.integrations.writeIntegrationPolicies);
  const canReadAgentPolicies = Boolean(fleet === null || fleet === void 0 ? void 0 : fleet.authz.fleet.readAgentPolicies);
  return {
    canReadAgentPolicies,
    canSaveIntegrations
  };
}
function useCanUpdatePrivateMonitor(monitor) {
  const {
    canSaveIntegrations
  } = useFleetPermissions();
  return canUpdatePrivateMonitor(monitor, canSaveIntegrations);
}
function useCanManagePrivateLocation() {
  const {
    canSaveIntegrations,
    canReadAgentPolicies
  } = useFleetPermissions();
  return Boolean(canSaveIntegrations && canReadAgentPolicies);
}
function canUpdatePrivateMonitor(monitor, canSaveIntegrations) {
  const locations = monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.LOCATIONS];
  const hasPrivateLocation = locations === null || locations === void 0 ? void 0 : locations.some(location => !location.isServiceManaged);
  return !(hasPrivateLocation && !canSaveIntegrations);
}