"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAbsoluteDate = useAbsoluteDate;
exports.useRefreshedRange = useRefreshedRange;
exports.useRefreshedRangeFromUrl = useRefreshedRangeFromUrl;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _contexts = require("../contexts");
var _use_url_params = require("./use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAbsoluteDate({
  from,
  to
}) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  return (0, _react.useMemo)(() => {
    var _datemath$parse$toISO, _datemath$parse, _datemath$parse$toISO2, _datemath$parse2;
    return {
      from: (_datemath$parse$toISO = (_datemath$parse = _datemath.default.parse(from)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.toISOString()) !== null && _datemath$parse$toISO !== void 0 ? _datemath$parse$toISO : from,
      to: (_datemath$parse$toISO2 = (_datemath$parse2 = _datemath.default.parse(to, {
        roundUp: true
      })) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.toISOString()) !== null && _datemath$parse$toISO2 !== void 0 ? _datemath$parse$toISO2 : to
    };
  },
  // we want to recompute these any time the app refreshes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [from, to, lastRefresh]);
}
function useRefreshedRange(inp, unit) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  return (0, _react.useMemo)(() => ({
    from: (0, _moment.default)(lastRefresh).subtract(inp, unit).toISOString(),
    to: new Date(lastRefresh).toISOString()
  }), [lastRefresh, inp, unit]);
}
const isDefaultRange = (from, to) => {
  return from === 'now-24h' && to === 'now';
};
function useRefreshedRangeFromUrl() {
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _use_url_params.useGetUrlParams)();
  const isDefault = isDefaultRange(dateRangeStart, dateRangeEnd);
  const absRange = useAbsoluteDate({
    from: dateRangeStart,
    to: dateRangeEnd
  });
  const defaultRange = useRefreshedRange(24, 'hours');
  return isDefault ? defaultRange : absRange;
}