"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepTabs = ({
  stepsList,
  step,
  loading
}) => {
  var _step$synthetics$step;
  let tabs = [{
    id: 'code',
    name: CODE_EXECUTED
  }, {
    id: 'console',
    name: CONSOLE_LABEL
  }];
  const isFailedStep = (step === null || step === void 0 ? void 0 : (_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  if (isFailedStep) {
    tabs = [{
      id: 'stackTrace',
      name: STACKTRACE_LABEL
    }, ...tabs];
  }
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('code');
  (0, _react.useEffect)(() => {
    if (isFailedStep) {
      setSelectedTabId('stackTrace');
    } else {
      setSelectedTabId('code');
    }
  }, [isFailedStep]);
  const getBrowserConsoles = (0, _react.useCallback)(index => {
    return stepsList === null || stepsList === void 0 ? void 0 : stepsList.filter(stepF => {
      var _stepF$synthetics, _stepF$synthetics2, _stepF$synthetics2$st;
      return ((_stepF$synthetics = stepF.synthetics) === null || _stepF$synthetics === void 0 ? void 0 : _stepF$synthetics.type) === 'journey/browserconsole' && ((_stepF$synthetics2 = stepF.synthetics) === null || _stepF$synthetics2 === void 0 ? void 0 : (_stepF$synthetics2$st = _stepF$synthetics2.step) === null || _stepF$synthetics2$st === void 0 ? void 0 : _stepF$synthetics2$st.index) === index;
    }).map(stepF => {
      var _stepF$synthetics3, _stepF$synthetics3$pa;
      return (_stepF$synthetics3 = stepF.synthetics) === null || _stepF$synthetics3 === void 0 ? void 0 : (_stepF$synthetics3$pa = _stepF$synthetics3.payload) === null || _stepF$synthetics3$pa === void 0 ? void 0 : _stepF$synthetics3$pa.text;
    });
  }, [stepsList]);
  if (!loading && (stepsList === null || stepsList === void 0 ? void 0 : stepsList.length) === 0) {
    return null;
  }
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
  };
  const renderTabs = () => {
    return tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: index,
      onClick: () => onSelectedTabChanged(tab.id),
      isSelected: tab.id === selectedTabId
    }, tab.name));
  };
  const renderTabContent = () => {
    var _step$synthetics, _step$synthetics$payl, _getBrowserConsoles, _step$synthetics2, _step$synthetics2$err, _step$synthetics3, _step$synthetics3$pay;
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null);
    }
    switch (selectedTabId) {
      case 'code':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript"
        }, step === null || step === void 0 ? void 0 : (_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$payl = _step$synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.source);
      case 'console':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript"
        }, (_getBrowserConsoles = getBrowserConsoles(1)) === null || _getBrowserConsoles === void 0 ? void 0 : _getBrowserConsoles.join('\n'));
      case 'stackTrace':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "html"
        }, step === null || step === void 0 ? void 0 : (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$err = _step$synthetics2.error) === null || _step$synthetics2$err === void 0 ? void 0 : _step$synthetics2$err.stack);
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          isCopyable: true,
          overflowHeight: "200px",
          language: "javascript"
        }, step === null || step === void 0 ? void 0 : (_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$pay = _step$synthetics3.payload) === null || _step$synthetics3$pay === void 0 ? void 0 : _step$synthetics3$pay.source);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, renderTabs()), renderTabContent());
};
exports.StepTabs = StepTabs;
const CODE_EXECUTED = _i18n.i18n.translate('xpack.synthetics.testDetails.codeExecuted', {
  defaultMessage: 'Code executed'
});
const STACKTRACE_LABEL = _i18n.i18n.translate('xpack.synthetics.testDetails.stackTrace', {
  defaultMessage: 'Stacktrace'
});
const CONSOLE_LABEL = _i18n.i18n.translate('xpack.synthetics.testDetails.console', {
  defaultMessage: 'Console'
});