"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListExpandedRowComponent = void 0;
var _format = require("@elastic/eui/lib/services/format");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ping_redirects = require("./ping_redirects");
var _headers = require("./headers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore formatNumber

const BodyDescription = ({
  body
}) => {
  const contentBytes = body.content_bytes || 0;
  const bodyBytes = body.bytes || 0;
  const truncatedText = contentBytes > 0 && contentBytes < bodyBytes ? _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.truncated', {
    defaultMessage: 'Showing first {contentBytes} bytes.',
    values: {
      contentBytes
    }
  }) : null;
  const bodySizeText = bodyBytes > 0 ? _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.bodySize', {
    defaultMessage: 'Body size is {bodyBytes}.',
    values: {
      bodyBytes: (0, _format.formatNumber)(bodyBytes, '0b')
    }
  }) : null;
  const combinedText = [truncatedText, bodySizeText].filter(s => s).join(' ');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, combinedText);
};
const BodyExcerpt = ({
  content
}) => content ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  overflowHeight: 250
}, content) : null;
const PingListExpandedRowComponent = ({
  ping
}) => {
  var _ping$http, _ping$http$response, _ping$http2, _ping$http2$response, _ping$http3, _ping$http3$response, _ping$http4, _ping$http4$response;
  const listItems = [];

  // Show the error block
  if (ping.error) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.error', {
        defaultMessage: 'Error'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, ping.error.message)
    });
  }

  // Show the body, if present
  if ((_ping$http = ping.http) !== null && _ping$http !== void 0 && (_ping$http$response = _ping$http.response) !== null && _ping$http$response !== void 0 && _ping$http$response.body) {
    const body = ping.http.response.body;
    listItems.push({
      title: _i18n.i18n.translate('xpack.synthetics.pingList.expandedRow.response_body', {
        defaultMessage: 'Response Body'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(BodyDescription, {
        body: body
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's'
      }), body.content ? /*#__PURE__*/_react.default.createElement(BodyExcerpt, {
        content: body.content || ''
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.testResults.expandedRow.response_body.notRecorded",
        defaultMessage: "Body not recorded. Set index response body option to \"On Always\" in advanced options of monitor configuration to record body."
      })))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, (ping === null || ping === void 0 ? void 0 : (_ping$http2 = ping.http) === null || _ping$http2 === void 0 ? void 0 : (_ping$http2$response = _ping$http2.response) === null || _ping$http2$response === void 0 ? void 0 : _ping$http2$response.redirects) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ping_redirects.PingRedirects, {
    monitorStatus: ping,
    showTitle: true
  })), (ping === null || ping === void 0 ? void 0 : (_ping$http3 = ping.http) === null || _ping$http3 === void 0 ? void 0 : (_ping$http3$response = _ping$http3.response) === null || _ping$http3$response === void 0 ? void 0 : _ping$http3$response.headers) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_headers.PingHeaders, {
    headers: ping === null || ping === void 0 ? void 0 : (_ping$http4 = ping.http) === null || _ping$http4 === void 0 ? void 0 : (_ping$http4$response = _ping$http4.response) === null || _ping$http4$response === void 0 ? void 0 : _ping$http4$response.headers
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: ping !== null && ping !== void 0 && ping.error ? 'danger' : 'primary'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems
  }))));
};
exports.PingListExpandedRowComponent = PingListExpandedRowComponent;