"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _contexts = require("../../../../../contexts");
var _waterfall_context = require("../context/waterfall_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddableMock = ({
  title,
  appendTitle,
  reportType,
  attributes
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h1", null, title), /*#__PURE__*/_react.default.createElement("div", {
  "aria-label": "append title"
}, appendTitle), /*#__PURE__*/_react.default.createElement("div", null, reportType), /*#__PURE__*/_react.default.createElement("div", {
  "aria-label": "attributes"
}, JSON.stringify(attributes)));
const TestWrapper = ({
  basePath,
  activeStep,
  children
}) => /*#__PURE__*/_react.default.createElement(_contexts.SyntheticsStartupPluginsContext.Provider, {
  value: {
    // @ts-expect-error incomplete implementation for test purposes
    exploratoryView: {
      ExploratoryViewEmbeddable: jest.fn(props => /*#__PURE__*/_react.default.createElement(EmbeddableMock, props))
    }
  }
}, /*#__PURE__*/_react.default.createElement(_waterfall_context.WaterfallContext.Provider, {
  value: {
    activeStep
  }
}, children));
exports.TestWrapper = TestWrapper;