"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/observability-plugin/public");
var _translations = require("../translations");
var _network_requests_total = require("./network_requests_total");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallSearch = ({
  query,
  setQuery,
  totalNetworkRequests,
  highlightedNetworkRequests,
  fetchedNetworkRequests
}) => {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'uptime'
  });
  const [value, setValue] = (0, _react.useState)(query);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _useDebounce.default)(() => {
    setQuery(value);
  }, 300, [value]);

  // indicates use of the query input box
  (0, _react.useEffect)(() => {
    if (query) {
      trackMetric({
        metric: 'waterfall_filter_input_changed',
        metricType: _public.METRIC_TYPE.CLICK
      });
    }
  }, [query, trackMetric]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    style: {
      marginRight: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, NETWORK_REQUESTS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "syntheticsWaterfallSearchFieldSearch",
    fullWidth: true,
    "aria-label": _translations.FILTER_REQUESTS_LABEL,
    placeholder: _translations.SEARCH_REQUESTS_LABEL,
    onChange: evt => {
      setValue(evt.target.value);
    },
    value: value
  }), /*#__PURE__*/_react.default.createElement(_network_requests_total.NetworkRequestsTotal, {
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests
  }));
};
exports.WaterfallSearch = WaterfallSearch;
const NETWORK_REQUESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.networkRequests.heading', {
  defaultMessage: 'Network Requests'
});