"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _waterfall_context = require("./context/waterfall_context");
var _styles = require("./styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Sidebar = ({
  items,
  render
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    onSidebarClick
  } = (0, _waterfall_context.useWaterfallContext)();
  const handleSidebarClick = (0, _react.useMemo)(() => onSidebarClick, [onSidebarClick]);
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: items.length * _constants.FIXED_AXIS_HEIGHT,
      overflow: 'hidden'
    },
    "data-test-subj": "wfSidebarContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      height: '100%'
    },
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: '100%',
      paddingTop: 1.5
    },
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, items.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      css: {
        outline: 0,
        minWidth: 0,
        // Needed for flex to not stretch noWrap children
        justifyContent: 'space-around',
        paddingRight: euiTheme.size.s
      }
    }, render(item, index, handleSidebarClick));
  })))));
};
exports.Sidebar = Sidebar;