"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPaletteFlexItem = exports.ColorPalette = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _data_formatting = require("../common/network_data/data_formatting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColorPalette = ({
  label,
  mimeType,
  percent,
  value,
  loading,
  delta,
  hasAnyThresholdBreach,
  labelWidth = 40,
  valueWidth = 65
}) => {
  const getToolTipContent = () => {
    return _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.label', {
      defaultMessage: 'Value is {deltaLabel} compared to steps in previous 24 hours.',
      values: {
        deltaLabel: Math.abs(delta) === 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.noChange', {
          defaultMessage: 'same'
        }) : delta > 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.increased', {
          defaultMessage: '{delta}% higher',
          values: {
            delta
          }
        }) : _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.decreased', {
          defaultMessage: '{delta}% lower',
          values: {
            delta
          }
        })
      }
    });
  };
  const getColor = () => {
    if (Math.abs(delta) < 5) {
      return 'default';
    }
    return delta > 5 ? 'danger' : 'success';
  };
  const hasDelta = Math.abs(delta) > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: labelWidth
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(ColorPaletteFlexItem, {
    mimeType: mimeType,
    percent: isNaN(percent) ? 0 : percent,
    loading: loading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: valueWidth,
      justifySelf: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      fontWeight: 'bold',
      whiteSpace: 'nowrap'
    },
    className: "eui-textRight",
    color: getColor()
  }, value)), hasAnyThresholdBreach && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 40
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent()
  }, hasDelta ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: delta > 0 ? 'sortUp' : 'sortDown',
    size: "m",
    color: getColor()
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: "m",
    color: "subdued"
  }))));
};
exports.ColorPalette = ColorPalette;
const ColorPaletteFlexItem = ({
  mimeType,
  percent,
  loading
}) => {
  const {
    eui
  } = (0, _public.useTheme)();
  const [value, setVal] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      if (value < percent) {
        setVal(value + 1);
      }
    }, 10);
  }, [percent, value]);
  (0, _react.useEffect)(() => {
    if (!loading) {
      setVal(0);
    }
  }, [loading]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(LoadingLine, {
      lines: 1
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    style: {
      borderRadius: 8,
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      backgroundColor: eui.euiColorLightShade
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      backgroundColor: _data_formatting.colourPalette[mimeType],
      height: 20,
      width: `${value}%`
    }
  })));
};
exports.ColorPaletteFlexItem = ColorPaletteFlexItem;
const LoadingLine = (0, _styledComponents.default)(_eui.EuiLoadingContent)`
  &&& {
    > span {
      height: 20px;
    }
  }
`;