"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepNav = exports.StepDetailPageStepNav = exports.STEP_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_step_detail_page = require("./hooks/use_step_detail_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepNav = ({
  stepIndex,
  totalSteps,
  handleStepHref
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const hasMoreThanOneStep = totalSteps > 1;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNavStepStepIndexOfTotalStepsButton",
    size: "s",
    flush: "left",
    iconType: hasMoreThanOneStep ? 'arrowDown' : undefined,
    iconSide: "right",
    onClick: onButtonClick,
    style: {
      height: 20
    },
    disabled: !hasMoreThanOneStep
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepDetail.totalSteps",
    defaultMessage: "Step {stepIndex} of {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    }
  }));
  const items = (0, _lodash.times)(totalSteps).map(num => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: num,
    href: handleStepHref(num + 1),
    onClick: closePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepDetail.stepNumber",
    defaultMessage: "Step {stepIndex}",
    values: {
      stepIndex: num + 1
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "stepDetailsStepNav",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
exports.StepNav = StepNav;
const StepDetailPageStepNav = () => {
  const {
    activeStep,
    journey,
    stepIndex,
    handleStepHref,
    stepEnds
  } = (0, _use_step_detail_page.useStepDetailPage)();
  if (!journey || !activeStep) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: STEP_LABEL,
      description: /*#__PURE__*/_react.default.createElement(StepNav, {
        stepIndex: stepIndex,
        totalSteps: stepEnds.length,
        handleStepHref: handleStepHref
      })
    }]
  });
};
exports.StepDetailPageStepNav = StepDetailPageStepNav;
const STEP_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.stepLabel', {
  defaultMessage: 'Step'
});
exports.STEP_LABEL = STEP_LABEL;