"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefinitionsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _labels = require("./labels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const definitionList = [{
  title: _labels.FCP_LABEL,
  description: _labels.FCP_TOOLTIP
}, {
  title: _labels.LCP_LABEL,
  description: _labels.LCP_HELP_LABEL
}, {
  title: _labels.CLS_LABEL,
  description: _labels.CLS_HELP_LABEL
}, {
  title: _labels.DCL_LABEL,
  description: _labels.DCL_TOOLTIP
}];
const DefinitionsPopover = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(prevPopoverOpen => !prevPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsDefinitionsPopoverButton",
      iconType: "list",
      iconSide: "right",
      onClick: onButtonClick
    }, DEFINITIONS_LABEL),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "rightCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, DEFINITIONS_LABEL), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '350px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: definitionList
  })));
};
exports.DefinitionsPopover = DefinitionsPopover;
const DEFINITIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.definition', {
  defaultMessage: 'Definitions'
});