"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _error_callout = require("./error_callout");
var _use_step_details_breadcrumbs = require("./hooks/use_step_details_breadcrumbs");
var _waterfall_chart_container = require("./step_waterfall_chart/waterfall/waterfall_chart_container");
var _network_timings_donut = require("./step_timing_breakdown/network_timings_donut");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _actions = require("../../state/network_events/actions");
var _object_weight_list = require("./step_objects/object_weight_list");
var _step_metrics = require("./step_metrics/step_metrics");
var _object_count_list = require("./step_objects/object_count_list");
var _monitor_details_portal = require("../monitor_add_edit/monitor_details_portal");
var _step_image = require("./step_screenshot/step_image");
var _breakdown_legend = require("./step_timing_breakdown/breakdown_legend");
var _network_timings_breakdown = require("./network_timings_breakdown");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDetailPage = () => {
  var _data$details, _data$details$journey, _data$details2, _data$details3, _data$details4;
  const {
    checkGroupId,
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'stepDetail'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'stepDetail',
    delay: 15000
  });
  const {
    data,
    isFailedStep,
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  (0, _use_step_details_breadcrumbs.useStepDetailsBreadcrumbs)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getNetworkEvents.get({
      checkGroup: checkGroupId,
      stepIndex: Number(stepIndex)
    }));
  }, [dispatch, stepIndex, checkGroupId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallOut, {
    step: currentStep
  }), (data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : (_data$details$journey = _data$details.journey) === null || _data$details$journey === void 0 ? void 0 : _data$details$journey.config_id) && /*#__PURE__*/_react.default.createElement(_monitor_details_portal.MonitorDetailsLinkPortal, {
    configId: data.details.journey.config_id,
    name: data.details.journey.monitor.name
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, (data === null || data === void 0 ? void 0 : (_data$details2 = data.details) === null || _data$details2 === void 0 ? void 0 : _data$details2.journey) && currentStep && /*#__PURE__*/_react.default.createElement(_step_image.StepImage, {
    ping: data === null || data === void 0 ? void 0 : (_data$details3 = data.details) === null || _data$details3 === void 0 ? void 0 : _data$details3.journey,
    step: currentStep,
    isFailed: isFailedStep
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      minWidth: 150
    }
  }, /*#__PURE__*/_react.default.createElement(_network_timings_donut.NetworkTimingsDonut, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      minWidth: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_breakdown_legend.BreakdownLegend, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    style: {
      minWidth: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_network_timings_breakdown.NetworkTimingsBreakdown, {
    monitorId: data === null || data === void 0 ? void 0 : (_data$details4 = data.details) === null || _data$details4 === void 0 ? void 0 : _data$details4.journey.monitor.id
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_step_metrics.StepMetrics, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_object_weight_list.ObjectWeightList, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_object_count_list.ObjectCountList, null)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), data && /*#__PURE__*/_react.default.createElement(_waterfall_chart_container.WaterfallChartContainer, {
    checkGroup: checkGroupId,
    stepIndex: Number(stepIndex),
    activeStep: currentStep
  }));
};
exports.StepDetailPage = StepDetailPage;