"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepDetailsBreadcrumbs = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _ui = require("../../../../../../common/constants/ui");
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _use_test_run_details_breadcrumbs = require("../../test_run_details/hooks/use_test_run_details_breadcrumbs");
var _plugin = require("../../../../../../common/constants/plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepDetailsBreadcrumbs = extraCrumbs => {
  var _kibana$services$appl, _kibana$services$appl2, _data$details, _selectedLocation$id, _ref, _currentStep$syntheti, _currentStep$syntheti2;
  const {
    data,
    currentStep
  } = (0, _use_journey_steps.useJourneySteps)();
  const kibana = (0, _public.useKibana)();
  const appPath = (_kibana$services$appl = (_kibana$services$appl2 = kibana.services.application) === null || _kibana$services$appl2 === void 0 ? void 0 : _kibana$services$appl2.getUrlForApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID)) !== null && _kibana$services$appl !== void 0 ? _kibana$services$appl : '';
  const params = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  (0, _use_test_run_details_breadcrumbs.useTestRunDetailsBreadcrumbs)([{
    text: data ? (0, _moment.default)((_data$details = data.details) === null || _data$details === void 0 ? void 0 : _data$details.timestamp).format('LLL') : '',
    href: `${appPath}/${(0, _reactRouterDom.generatePath)(_ui.TEST_RUN_DETAILS_ROUTE, params)}?locationId=${(_selectedLocation$id = selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id) !== null && _selectedLocation$id !== void 0 ? _selectedLocation$id : ''}`
  }, {
    text: (_ref = `${currentStep === null || currentStep === void 0 ? void 0 : (_currentStep$syntheti = currentStep.synthetics.step) === null || _currentStep$syntheti === void 0 ? void 0 : _currentStep$syntheti.index}. ${currentStep === null || currentStep === void 0 ? void 0 : (_currentStep$syntheti2 = currentStep.synthetics.step) === null || _currentStep$syntheti2 === void 0 ? void 0 : _currentStep$syntheti2.name}`) !== null && _ref !== void 0 ? _ref : ''
  }]);
};
exports.useStepDetailsBreadcrumbs = useStepDetailsBreadcrumbs;