"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectAPIKeys = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/observability-plugin/public");
var _help_commands = require("./help_commands");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _api = require("../../../state/monitor_management/api");
var _api_key_btn = require("./api_key_btn");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const syntheticsTestRunDocsLink = 'https://www.elastic.co/guide/en/observability/current/synthetic-run-tests.html';
const ProjectAPIKeys = () => {
  var _kServices$fleet, _useKibana$services, _useKibana$services$a;
  const {
    loading: enablementLoading,
    enablement: {
      canManageApiKeys
    }
  } = (0, _hooks.useEnablement)();
  const [apiKey, setApiKey] = (0, _react.useState)(undefined);
  const [loadAPIKey, setLoadAPIKey] = (0, _react.useState)(false);
  const kServices = (0, _public.useKibana)().services;
  const canSaveIntegrations = !!(kServices !== null && kServices !== void 0 && (_kServices$fleet = kServices.fleet) !== null && _kServices$fleet !== void 0 && _kServices$fleet.authz.integrations.writeIntegrationPolicies);
  const {
    data,
    loading
  } = (0, _public2.useFetcher)(async () => {
    if (loadAPIKey) {
      return (0, _api.fetchServiceAPIKey)();
    }
    return null;
  }, [loadAPIKey]);
  (0, _react.useEffect)(() => {
    setApiKey(data === null || data === void 0 ? void 0 : data.apiKey.encoded);
  }, [data]);
  const canSave = !!((_useKibana$services = (0, _public.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && _useKibana$services$a.capabilities.uptime.save);
  if (enablementLoading) {
    return /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    style: {
      maxWidth: '50%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", null, GET_API_KEY_GENERATE),
    body: canSave && canManageApiKeys ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, GET_API_KEY_LABEL_DESCRIPTION, ' ', !canSaveIntegrations ? `${API_KEY_DISCLAIMER} ` : '', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsProjectAPIKeysLink",
      href: syntheticsTestRunDocsLink,
      external: true,
      target: "_blank"
    }, LEARN_MORE_LABEL))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, GET_API_KEY_REDUCED_PERMISSIONS_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsProjectAPIKeysLink",
      href: syntheticsTestRunDocsLink,
      external: true,
      target: "_blank"
    }, LEARN_MORE_LABEL))),
    actions: /*#__PURE__*/_react.default.createElement(_api_key_btn.ApiKeyBtn, {
      loading: loading,
      setLoadAPIKey: setLoadAPIKey,
      apiKey: apiKey,
      isDisabled: !canSave || !canManageApiKeys
    })
  }), apiKey && /*#__PURE__*/_react.default.createElement(_help_commands.HelpCommands, {
    apiKey: apiKey
  }));
};
exports.ProjectAPIKeys = ProjectAPIKeys;
const LEARN_MORE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.learnMore.label', {
  defaultMessage: 'Learn more'
});
const GET_API_KEY_GENERATE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getProjectAPIKeyLabel.generate', {
  defaultMessage: 'Generate Project API Key'
});
const GET_API_KEY_LABEL_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyLabel.description', {
  defaultMessage: 'Use an API key to push monitors remotely from a CLI or CD pipeline.'
});
const API_KEY_DISCLAIMER = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyLabel.disclaimer', {
  defaultMessage: 'Please note: In order to use push monitors using private testing locations, you must generate this API key with a user who has Fleet and Integrations write permissions.'
});
const GET_API_KEY_REDUCED_PERMISSIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.getAPIKeyReducedPermissions.description', {
  defaultMessage: 'Use an API key to push monitors remotely from a CLI or CD pipeline. To generate an API key, you must have permissions to manage API keys and Uptime write access. Please contact your administrator.'
});