"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivateLocationsTable = exports.MONITORS = exports.LEARN_MORE = exports.AGENT_POLICY_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _view_location_monitors = require("./view_location_monitors");
var _table_title = require("../../common/components/table_title");
var _tags_field = require("../components/tags_field");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _private_locations = require("../../../state/private_locations");
var _empty_locations = require("./empty_locations");
var _permissions = require("../../common/components/permissions");
var _delete_location = require("./delete_location");
var _use_location_monitors = require("./hooks/use_location_monitors");
var _policy_name = require("./policy_name");
var _location_form = require("./location_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivateLocationsTable = ({
  deleteLoading,
  onDelete,
  privateLocations
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const {
    locationMonitors,
    loading
  } = (0, _use_location_monitors.useLocationMonitors)();
  const {
    canSave
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const canManagePrivateLocations = (0, _hooks.useCanManagePrivateLocation)();
  const tagsList = privateLocations.reduce((acc, item) => {
    const tags = item.tags || [];
    return new Set([...acc, ...tags]);
  }, new Set());
  const columns = [{
    field: 'label',
    name: _location_form.LOCATION_NAME_LABEL
  }, {
    field: 'monitors',
    name: MONITORS,
    render: (monitors, item) => /*#__PURE__*/_react.default.createElement(_view_location_monitors.ViewLocationMonitors, {
      count: monitors,
      locationName: item.label
    })
  }, {
    field: 'agentPolicyId',
    name: AGENT_POLICY_LABEL,
    render: agentPolicyId => /*#__PURE__*/_react.default.createElement(_policy_name.PolicyName, {
      agentPolicyId: agentPolicyId
    })
  }, {
    name: _tags_field.TAGS_LABEL,
    field: 'tags',
    sortable: true,
    render: val => {
      const tags = val !== null && val !== void 0 ? val : [];
      if (tags.length === 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "--");
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        wrap: true
      }, tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: tag
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, tag))));
    }
  }, {
    name: ACTIONS_LABEL,
    actions: [{
      name: DELETE_LOCATION,
      description: DELETE_LOCATION,
      render: item => /*#__PURE__*/_react.default.createElement(_delete_location.DeleteLocation, {
        id: item.id,
        label: item.label,
        locationMonitors: locationMonitors,
        onDelete: onDelete,
        loading: deleteLoading
      }),
      isPrimary: true,
      'data-test-subj': 'action-delete'
    }]
  }];
  const items = privateLocations.map(location => {
    var _locationMonitors$fin, _locationMonitors$fin2;
    return {
      ...location,
      monitors: (_locationMonitors$fin = locationMonitors === null || locationMonitors === void 0 ? void 0 : (_locationMonitors$fin2 = locationMonitors.find(l => l.id === location.id)) === null || _locationMonitors$fin2 === void 0 ? void 0 : _locationMonitors$fin2.count) !== null && _locationMonitors$fin !== void 0 ? _locationMonitors$fin : 0
    };
  });
  const setIsAddingNew = val => dispatch((0, _private_locations.setAddingNewPrivateLocation)(val));
  const renderToolRight = () => {
    return [/*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canSave
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "addPrivateLocationButton",
      fill: true,
      "data-test-subj": 'addPrivateLocationButton',
      isLoading: loading,
      disabled: !canManagePrivateLocations || !canSave,
      onClick: () => setIsAddingNew(true),
      iconType: "plusInCircle",
      title: !canManagePrivateLocations ? _permissions.CANNOT_SAVE_INTEGRATION_LABEL : undefined
    }, ADD_LABEL))];
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _empty_locations.START_ADDING_LOCATIONS_DESCRIPTION, " ", /*#__PURE__*/_react.default.createElement(_empty_locations.PrivateLocationDocsLink, {
    label: LEARN_MORE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: 'id',
    tableLayout: "auto",
    tableCaption: PRIVATE_LOCATIONS,
    items: items,
    columns: columns,
    childrenBetween: /*#__PURE__*/_react.default.createElement(_table_title.TableTitle, {
      total: items.length,
      label: PRIVATE_LOCATIONS,
      pageIndex: pageIndex,
      pageSize: pageSize
    }),
    pagination: {
      pageSize,
      pageIndex
    },
    onTableChange: ({
      page
    }) => {
      var _page$index, _page$size;
      setPageIndex((_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : 0);
      setPageSize((_page$size = page === null || page === void 0 ? void 0 : page.size) !== null && _page$size !== void 0 ? _page$size : 10);
    },
    search: {
      toolsRight: renderToolRight(),
      box: {
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'tags',
        name: _tags_field.TAGS_LABEL,
        multiSelect: true,
        options: [...tagsList].map(tag => ({
          value: tag,
          name: tag,
          view: tag
        }))
      }]
    }
  }));
};
exports.PrivateLocationsTable = PrivateLocationsTable;
const PRIVATE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocations', {
  defaultMessage: 'Private locations'
});
const ACTIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.actions', {
  defaultMessage: 'Actions'
});
const MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitors', {
  defaultMessage: 'Monitors'
});
exports.MONITORS = MONITORS;
const AGENT_POLICY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentPolicy', {
  defaultMessage: 'Agent Policy'
});
exports.AGENT_POLICY_LABEL = AGENT_POLICY_LABEL;
const DELETE_LOCATION = _i18n.i18n.translate('xpack.synthetics.settingsRoute.privateLocations.deleteLabel', {
  defaultMessage: 'Delete private location'
});
const ADD_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createLocation', {
  defaultMessage: 'Create location'
});
const LEARN_MORE = _i18n.i18n.translate('xpack.synthetics.privateLocations.learnMore.label', {
  defaultMessage: 'Learn more.'
});
exports.LEARN_MORE = LEARN_MORE;