"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocationMonitors = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _saved_objects = require("../../../../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLocationMonitors = () => {
  const {
    savedObjects
  } = (0, _public2.useKibana)().services;
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    const aggs = {
      locations: {
        terms: {
          field: `${_saved_objects.monitorAttributes}.locations.id`,
          size: 10000
        }
      }
    };
    return savedObjects === null || savedObjects === void 0 ? void 0 : savedObjects.client.find({
      type: _saved_objects.syntheticsMonitorType,
      perPage: 0,
      aggs
    });
  }, []);
  return (0, _react.useMemo)(() => {
    if (data !== null && data !== void 0 && data.aggregations) {
      var _data$aggregations;
      const newValues = (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.locations.buckets.map(({
        key,
        doc_count: count
      }) => ({
        id: key,
        count
      }));
      return {
        locationMonitors: newValues,
        loading
      };
    }
    return {
      locationMonitors: [],
      loading
    };
  }, [data, loading]);
};
exports.useLocationMonitors = useLocationMonitors;