"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLocationFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_fleet_permissions = require("../../../hooks/use_fleet_permissions");
var _use_form_wrapped = require("../../../../../hooks/use_form_wrapped");
var _permissions = require("../../common/components/permissions");
var _location_form = require("./location_form");
var _manage_empty_state = require("./manage_empty_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddLocationFlyout = ({
  onSubmit,
  setIsOpen,
  privateLocations,
  isLoading
}) => {
  const form = (0, _use_form_wrapped.useFormWrapped)({
    mode: 'onSubmit',
    reValidateMode: 'onChange',
    shouldFocusError: true,
    defaultValues: {
      label: '',
      agentPolicyId: '',
      id: '',
      geo: {
        lat: 0,
        lon: 0
      },
      concurrentMonitors: 1
    }
  });
  const {
    handleSubmit
  } = form;
  const canManagePrivateLocation = (0, _use_fleet_permissions.useCanManagePrivateLocation)();
  const closeFlyout = () => {
    setIsOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    style: {
      width: 540
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, ADD_PRIVATE_LOCATION))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_manage_empty_state.ManageEmptyState, {
    privateLocations: privateLocations,
    hasFleetPermissions: canManagePrivateLocation,
    showEmptyLocations: false
  }, !canManagePrivateLocation && /*#__PURE__*/_react.default.createElement(_permissions.FleetPermissionsCallout, null), /*#__PURE__*/_react.default.createElement(_location_form.LocationForm, {
    privateLocations: privateLocations,
    hasPermissions: canManagePrivateLocation
  }))), canManagePrivateLocation && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsAddLocationFlyoutButton",
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    isLoading: isLoading
  }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAddLocationFlyoutButton",
    fill: true,
    onClick: handleSubmit(onSubmit),
    isLoading: isLoading
  }, SAVE_LABEL))))));
};
exports.AddLocationFlyout = AddLocationFlyout;
const ADD_PRIVATE_LOCATION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createPrivateLocations', {
  defaultMessage: 'Create private location'
});
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cancelLabel', {
  defaultMessage: 'Cancel'
});
const SAVE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.saveLabel', {
  defaultMessage: 'Save'
});