"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyNameLabel = exports.PolicyLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/index-lifecycle-management-plugin/public");
var _public3 = require("@kbn/observability-plugin/public");
var _i18n = require("@kbn/i18n");
var _contexts = require("../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyLink = ({
  name
}) => {
  var _application$capabili, _application$capabili2;
  const {
    share,
    application
  } = (0, _public.useKibana)().services;
  const canManageILM = (_application$capabili = application.capabilities.management) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.data) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.index_lifecycle_management;
  const ilmLocator = share.url.locators.get(_public2.ILM_LOCATOR_ID);
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    data
  } = (0, _public3.useFetcher)(async () => {
    return ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getLocation({
      page: 'policy_edit',
      policyName: name
    });
  }, [name]);
  if (!data) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 1
    });
  }
  if (!name) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "--");
  }
  if (!canManageILM) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: PERMISSIONS_NEEDED
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, name));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${basePath}/app/${data.app}${data.path}`,
    target: "_blank",
    "data-test-subj": name + 'PolicyLink'
  }, name);
};
exports.PolicyLink = PolicyLink;
const PolicyNameLabel = () => {
  var _application$capabili3, _application$capabili4;
  const {
    application
  } = (0, _public.useKibana)().services;
  const canManageILM = (_application$capabili3 = application.capabilities.management) === null || _application$capabili3 === void 0 ? void 0 : (_application$capabili4 = _application$capabili3.data) === null || _application$capabili4 === void 0 ? void 0 : _application$capabili4.index_lifecycle_management;
  if (canManageILM) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, POLICY_LABEL);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, POLICY_LABEL, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: PERMISSIONS_NEEDED,
    position: "right"
  }));
};
exports.PolicyNameLabel = PolicyNameLabel;
const POLICY_LABEL = _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.policy', {
  defaultMessage: 'Policy'
});
const PERMISSIONS_NEEDED = _i18n.i18n.translate('xpack.synthetics.settingsRoute.policy.manageILM', {
  defaultMessage: 'You need the "manage_ilm" cluster permission to manage ILM policies.'
});