"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetIlmPolicies = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _use_object_metrics = require("../../step_details_page/hooks/use_object_metrics");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const policyLabels = [{
  name: 'synthetics',
  label: _i18n.i18n.translate('xpack.synthetics.settingsRoute.allChecks', {
    defaultMessage: 'All Checks'
  }),
  indexTemplate: 'synthetics'
}, {
  name: 'synthetics-synthetics.browser-default_policy',
  label: _i18n.i18n.translate('xpack.synthetics.settingsRoute.browserChecks', {
    defaultMessage: 'Browser Checks'
  }),
  indexTemplate: 'synthetics-browser'
}, {
  name: 'synthetics-synthetics.browser_network-default_policy',
  label: _i18n.i18n.translate('xpack.synthetics.settingsRoute.browserNetworkRequests', {
    defaultMessage: 'Browser Network Requests'
  }),
  indexTemplate: 'synthetics-browser.network'
}, {
  name: 'synthetics-synthetics.browser_screenshot-default_policy',
  label: 'Browser Screenshots',
  indexTemplate: 'synthetics-browser.screenshot'
}, {
  name: 'synthetics-synthetics.http-default_policy',
  label: 'HTTP Pings',
  indexTemplate: 'synthetics-http'
}, {
  name: 'synthetics-synthetics.icmp-default_policy',
  label: 'ICMP Pings',
  indexTemplate: 'synthetics-icmp'
}, {
  name: 'synthetics-synthetics.tcp-default_policy',
  label: 'TCP Pings',
  indexTemplate: 'synthetics-tcp'
}];
const useGetIlmPolicies = () => {
  var _data$filter;
  const {
    data,
    error,
    loading
  } = (0, _public.useFetcher)(async () => {
    return (0, _api.getIlmPolicies)();
  }, []);
  const {
    data: sizeData,
    loading: indicesLoading
  } = (0, _public.useFetcher)(async () => {
    return (0, _api.getIndicesData)();
  }, []);
  const syntheticsILMPolicies = (_data$filter = data === null || data === void 0 ? void 0 : data.filter(({
    indexTemplates
  }) => indexTemplates === null || indexTemplates === void 0 ? void 0 : indexTemplates.some(indTemp => indTemp.includes('synthetics')))) !== null && _data$filter !== void 0 ? _data$filter : [];
  return {
    data: policyLabels.map(({
      name,
      label,
      indexTemplate
    }) => {
      var _sizeData$data, _policyIndices$reduce, _policy$policy$phases;
      const policy = syntheticsILMPolicies.find(p => {
        var _p$indexTemplates;
        return (_p$indexTemplates = p.indexTemplates) === null || _p$indexTemplates === void 0 ? void 0 : _p$indexTemplates.some(indTemp => indTemp.includes(indexTemplate));
      });
      const policyIndices = sizeData === null || sizeData === void 0 ? void 0 : (_sizeData$data = sizeData.data) === null || _sizeData$data === void 0 ? void 0 : _sizeData$data.filter(d => {
        var _policy$indices;
        return policy === null || policy === void 0 ? void 0 : (_policy$indices = policy.indices) === null || _policy$indices === void 0 ? void 0 : _policy$indices.includes(d.index);
      });
      let totalSize = (_policyIndices$reduce = policyIndices === null || policyIndices === void 0 ? void 0 : policyIndices.reduce((acc, curr) => {
        var _ref;
        return (_ref = acc + Number(curr === null || curr === void 0 ? void 0 : curr['store.size'])) !== null && _ref !== void 0 ? _ref : 0;
      }, 0)) !== null && _policyIndices$reduce !== void 0 ? _policyIndices$reduce : 0;
      const phases = (_policy$policy$phases = policy === null || policy === void 0 ? void 0 : policy.policy.phases) !== null && _policy$policy$phases !== void 0 ? _policy$policy$phases : {};
      const deletePhase = phases.delete;
      if (name === 'synthetics') {
        var _sizeData$data$reduce, _sizeData$data2;
        totalSize = (_sizeData$data$reduce = sizeData === null || sizeData === void 0 ? void 0 : (_sizeData$data2 = sizeData.data) === null || _sizeData$data2 === void 0 ? void 0 : _sizeData$data2.reduce((acc, curr) => {
          var _ref2;
          return (_ref2 = acc + Number(curr === null || curr === void 0 ? void 0 : curr['store.size'])) !== null && _ref2 !== void 0 ? _ref2 : 0;
        }, 0)) !== null && _sizeData$data$reduce !== void 0 ? _sizeData$data$reduce : 0;
      }
      return {
        name,
        label,
        policy,
        retentionPeriod: formatAge(deletePhase === null || deletePhase === void 0 ? void 0 : deletePhase.min_age),
        currentSize: (0, _use_object_metrics.formatBytes)(totalSize)
      };
    }),
    error,
    loading: loading || indicesLoading
  };
};
exports.useGetIlmPolicies = useGetIlmPolicies;
const formatAge = age => {
  if (!age) {
    return '--';
  }
  const [value] = age.split('d');
  return _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.retentionPeriodValue', {
    defaultMessage: '{value} days + rollover',
    values: {
      value
    }
  });
};