"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateEmail = exports.hasInvalidEmail = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateEmail = email => {
  return email.toLowerCase().match(/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/);
};
exports.validateEmail = validateEmail;
const REQUIRED_EMAIL = _i18n.i18n.translate('xpack.synthetics.settings.alertDefaultForm.requiredEmail', {
  defaultMessage: 'To: Email is required for selected email connector'
});
const getInvalidEmailError = value => {
  if (!value) {
    return;
  }
  const inValidEmail = value.find(val => !validateEmail(val));
  if (!inValidEmail) {
    return;
  }
  return _i18n.i18n.translate('xpack.synthetics.sourceConfiguration.alertDefaultForm.invalidEmail', {
    defaultMessage: '{val} is not a valid email.',
    values: {
      val: inValidEmail
    }
  });
};
const hasInvalidEmail = (defaultConnectors, value, isTouched) => {
  if (!defaultConnectors || defaultConnectors.length === 0 || isTouched === false) {
    return {};
  }
  if (!value || !value.to) {
    return {
      to: REQUIRED_EMAIL
    };
  }
  const toError = value.to.length === 0 ? REQUIRED_EMAIL : getInvalidEmailError(value.to);
  const ccError = getInvalidEmailError(value.cc);
  const bccError = getInvalidEmailError(value.bcc);
  if (toError || ccError || bccError) {
    return {
      to: toError !== null && toError !== void 0 ? toError : '',
      cc: ccError !== null && ccError !== void 0 ? ccError : '',
      bcc: bccError !== null && bccError !== void 0 ? bccError : ''
    };
  }
  return {};
};
exports.hasInvalidEmail = hasInvalidEmail;