"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInfiniteScroll = void 0;
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _react = require("react");
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _reactRedux = require("react-redux");
var _hooks = require("../../../../hooks");
var _state = require("../../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInfiniteScroll = ({
  intersectionRef,
  monitorsSortedByStatus
}) => {
  const [page, setPage] = (0, _react.useState)(1);
  const [loadNextPage, setLoadNextPage] = (0, _react.useState)(false);
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const {
    pageState: {
      perPage,
      sortField
    },
    data: {
      monitors
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const currentMonitors = getCurrentMonitors({
    monitors,
    monitorsSortedByStatus,
    perPage,
    page,
    sortField,
    statusFilter
  });
  const intersection = (0, _useIntersection.default)(intersectionRef, {
    root: null,
    rootMargin: '640px',
    // Height of 4 rows of monitors, minus the gutters
    threshold: 0.1
  });
  const hasIntersected = intersection && intersection.intersectionRatio > 0;
  (0, _useThrottle.default)(() => {
    if (hasIntersected && currentMonitors.length === page * perPage && currentMonitors.length !== monitors.length) {
      setLoadNextPage(true);
    } else {
      setLoadNextPage(false);
    }
  }, 1000);
  (0, _react.useEffect)(() => {
    if (loadNextPage) {
      setPage(p => p + 1);
      setLoadNextPage(false);
    }
  }, [loadNextPage]);
  return {
    currentMonitors
  };
};
exports.useInfiniteScroll = useInfiniteScroll;
const getCurrentMonitors = ({
  sortField,
  perPage,
  page,
  monitors,
  monitorsSortedByStatus,
  statusFilter
}) => {
  if (sortField === 'status' || statusFilter) {
    return monitorsSortedByStatus.slice(0, perPage * page);
  } else {
    return monitors.slice(0, perPage * page);
  }
};