"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPaginationInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _overview = require("../../../../state/overview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewPaginationInfo = ({
  page,
  loading,
  total,
  startRange,
  endRange
}) => {
  const {
    loaded
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  return loaded && total !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, startRange && endRange ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.overview.pagination.description",
    defaultMessage: "Showing {currentCount} of {total} {monitors}",
    values: {
      currentCount: /*#__PURE__*/_react.default.createElement("strong", null, `${startRange}-${endRange}`),
      total,
      monitors: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.overview.monitors.label",
        defaultMessage: "Monitors"
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.management.monitorList.recordTotal",
    defaultMessage: "Showing {total} {monitorsLabel}",
    values: {
      total: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: total
      })),
      monitorsLabel: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.management.monitorList.recordRangeLabel",
        defaultMessage: "{monitorCount, plural, one {Monitor} other {Monitors}}",
        values: {
          monitorCount: total
        }
      }))
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "syntheticsOverviewMonitorsLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.overview.pagination.loading",
    defaultMessage: "Loading Monitors..."
  }))));
};
exports.OverviewPaginationInfo = OverviewPaginationInfo;