"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGridItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _metric_item = require("./metric_item");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewGridItem = ({
  monitor,
  onClick
}) => {
  var _useLocationName, _monitor$location, _monitor$location2, _monitor$location3;
  const locationName = ((_useLocationName = (0, _hooks.useLocationName)({
    locationId: (_monitor$location = monitor.location) === null || _monitor$location === void 0 ? void 0 : _monitor$location.id
  })) === null || _useLocationName === void 0 ? void 0 : _useLocationName.label) || ((_monitor$location2 = monitor.location) === null || _monitor$location2 === void 0 ? void 0 : _monitor$location2.id);
  const {
    timestamp
  } = (0, _hooks.useStatusByLocationOverview)(monitor.configId, locationName);
  const {
    data,
    medianDuration,
    maxDuration,
    avgDuration,
    minDuration
  } = (0, _hooks.useLast50DurationChart)({
    locationId: (_monitor$location3 = monitor.location) === null || _monitor$location3 === void 0 ? void 0 : _monitor$location3.id,
    monitorId: monitor.id,
    timestamp
  });
  return /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    data: data,
    monitor: monitor,
    medianDuration: medianDuration,
    maxDuration: maxDuration,
    avgDuration: avgDuration,
    minDuration: minDuration,
    onClick: onClick
  });
};
exports.OverviewGridItem = OverviewGridItem;